/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.eclipse.handlers;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.Teacher;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CheckHandler
extends AbstractHandler {
    private static final String ERROR_NO_PROJECT = "Selecciona un proyecto Java antes de pedir correcciones";
    private static final String ERROR_CLOSED = "El proyecto seleccionado debe estar abierto";
    private static final String ERROR_COMPILATION = "El proyecto no debe contener errores de compilacion";
    private Teacher teacher = Teacher.getInstance();
    private IJavaProject lastCheck = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IStructuredSelection selection = (IStructuredSelection)window.getSelectionService().getSelection("org.eclipse.jdt.ui.PackageExplorer");
        if (selection == null) {
            selection = (IStructuredSelection)window.getSelectionService().getSelection("org.eclipse.ui.navigator.ProjectExplorer");
        }
        Object object = null;
        if (selection != null) {
            object = selection.getFirstElement();
        }
        IJavaProject project = null;
        if (IJavaProject.class.isInstance(object)) {
            project = (IJavaProject)object;
        } else if (IProject.class.isInstance(object)) {
            project = JavaCore.create((IProject)((IProject)object));
        }
        if (project == null && this.lastCheck != null) {
            project = this.lastCheck;
        }
        if (project != null && project.exists() && !this.hasCompilationErrors(project)) {
            this.lastCheck = project;
            this.teacher.check(project);
        } else if (project == null) {
            MessageDialog.openInformation(null, (String)"Ayudante Virtual", (String)ERROR_NO_PROJECT);
        } else if (!project.exists()) {
            MessageDialog.openInformation(null, (String)"Ayudante Virtual", (String)ERROR_CLOSED);
        } else if (this.hasCompilationErrors(project)) {
            MessageDialog.openInformation(null, (String)"Ayudante Virtual", (String)ERROR_COMPILATION);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasCompilationErrors(IJavaProject javaProject) {
        try {
            IMarker[] problems = javaProject.getProject().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int problemsIndex = 0;
            while (true) {
                if (problemsIndex >= problems.length) {
                    return false;
                }
                if (2 == problems[problemsIndex].getAttribute("severity", 0)) {
                    return true;
                }
                ++problemsIndex;
            }
        }
        catch (CoreException coreException) {
            return true;
        }
    }
}

