/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IBinding;

public class ConstructorInvocationPrologConverter
extends NodeConverter<ConstructorInvocation> {
    private static final String KEY = "constructor_invocation";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[7];
        stringArray[1] = "parent";
        stringArray[2] = "constructor";
        stringArray[3] = "arguments";
        stringArray[4] = "body_declaration";
        stringArray[5] = "type_declaration";
        stringArray[6] = "compilation_unit";
        KEYS = stringArray;
    }

    public ConstructorInvocationPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(ConstructorInvocation node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        String constructor = this.mapper.getBindingID((IBinding)node.resolveConstructorBinding());
        Vector<ASTNode> arguments_nodes = new Vector<ASTNode>();
        arguments_nodes.addAll(node.arguments());
        for (ASTNode argument : arguments_nodes) {
            this.converter_factory.getConverter(argument).convert(argument);
        }
        String arguments = this.generateList(arguments_nodes);
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, constructor, arguments, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(ConstructorInvocation node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        Vector arguments_nodes = new Vector();
        arguments_nodes.addAll(node.arguments());
        for (ASTNode argument : arguments_nodes) {
            this.converter_factory.getConverter(argument).bind(argument);
        }
        Vector arguments_types_nodes = new Vector();
        arguments_types_nodes.addAll(node.typeArguments());
        for (ASTNode type_argument_node : arguments_types_nodes) {
            this.converter_factory.getConverter(type_argument_node).bind(type_argument_node);
        }
    }
}

