/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ForStatement;

public class ForStatementPrologConverter
extends NodeConverter<ForStatement> {
    private static final String KEY = "for_statement";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[9];
        stringArray[1] = "parent";
        stringArray[2] = "initializers";
        stringArray[3] = "expression";
        stringArray[4] = "updaters";
        stringArray[5] = "body";
        stringArray[6] = "body_declaration";
        stringArray[7] = "type_declaration";
        stringArray[8] = "compilation_unit";
        KEYS = stringArray;
    }

    public ForStatementPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(ForStatement node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        Vector<ASTNode> initializers_nodes = new Vector<ASTNode>();
        initializers_nodes.addAll(node.initializers());
        for (ASTNode initializer : initializers_nodes) {
            this.converter_factory.getConverter(initializer).convert(initializer);
        }
        String initializers = this.generateList(initializers_nodes);
        this.converter_factory.getConverter((ASTNode)node.getExpression()).convert(node.getExpression());
        String expression = this.mapper.getNodeID((ASTNode)node.getExpression());
        Vector<ASTNode> updaters_nodes = new Vector<ASTNode>();
        updaters_nodes.addAll(node.updaters());
        for (ASTNode aSTNode : updaters_nodes) {
            this.converter_factory.getConverter(aSTNode).convert(aSTNode);
        }
        String string = this.generateList(updaters_nodes);
        this.converter_factory.getConverter((ASTNode)node.getBody()).convert(node.getBody());
        String body = this.mapper.getNodeID((ASTNode)node.getBody());
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, initializers, expression, string, body, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(ForStatement node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        Vector initializers_nodes = new Vector();
        initializers_nodes.addAll(node.initializers());
        for (ASTNode initializer : initializers_nodes) {
            this.converter_factory.getConverter(initializer).bind(initializer);
        }
        this.converter_factory.getConverter((ASTNode)node.getExpression()).bind(node.getExpression());
        Vector updaters_nodes = new Vector();
        updaters_nodes.addAll(node.updaters());
        for (ASTNode updaters : updaters_nodes) {
            this.converter_factory.getConverter(updaters).bind(updaters);
        }
        this.converter_factory.getConverter((ASTNode)node.getBody()).bind(node.getBody());
    }
}

