/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.parser;

import ar.edu.unicen.isistan.si.soploon.server.models.SourceCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class CodeParser {
    private static final String MONITOR_TITLE = "Generando arbol sintactico";
    private ASTParser parser = ASTParser.newParser((int)8);
    private HashMap<CompilationUnit, String> units;

    public CodeParser() {
        this.parser.setKind(8);
        this.units = new HashMap();
    }

    private CompilationUnit parse(ICompilationUnit compilation_unit) {
        this.parser.setSource(compilation_unit);
        this.parser.setResolveBindings(true);
        CompilationUnit c = (CompilationUnit)this.parser.createAST(null);
        return c;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int process(IJavaProject project, IProgressMonitor monitor) {
        this.units.clear();
        try {
            IPackageFragment[] packages = project.getPackageFragments();
            Vector<IPackageFragment> packages_source = new Vector<IPackageFragment>();
            IPackageFragment[] iPackageFragmentArray = packages;
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment actual_package = iPackageFragmentArray[n2];
                if (actual_package.getKind() == 1) {
                    packages_source.add(actual_package);
                }
                ++n2;
            }
            if (monitor.isCanceled()) {
                monitor.done();
            }
            monitor.beginTask(MONITOR_TITLE, packages_source.size());
            for (IPackageFragment actual_package : packages_source) {
                ICompilationUnit[] compilation_units;
                ICompilationUnit[] iCompilationUnitArray = compilation_units = actual_package.getCompilationUnits();
                int n3 = compilation_units.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICompilationUnit icompilationUnit = iCompilationUnitArray[n4];
                    CompilationUnit compilationUnit = this.parse(icompilationUnit);
                    this.units.put(compilationUnit, icompilationUnit.getSource());
                    if (monitor.isCanceled()) {
                        monitor.done();
                        return 1;
                    }
                    ++n4;
                }
                monitor.worked(1);
            }
            return 0;
        }
        catch (Exception exception) {
            monitor.done();
            return -1;
        }
    }

    public ArrayList<CompilationUnit> getUnits() {
        return new ArrayList<CompilationUnit>(this.units.keySet());
    }

    public ArrayList<SourceCode> toSourceCodes() {
        ArrayList<SourceCode> sourceCodes = new ArrayList<SourceCode>();
        for (CompilationUnit cunit : this.units.keySet()) {
            SourceCode sourceCode = new SourceCode();
            sourceCode.setPath(cunit.getJavaElement().getPath().toString());
            sourceCode.setCode(this.units.get(cunit));
            sourceCodes.add(sourceCode);
        }
        return sourceCodes;
    }
}

